unit customform;

interface

// Needs TPNGImage, see http://pngdelphi.sourceforge.net/

uses

  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, inifiles, ExtCtrls, jpeg, pub, pngimage;

type
  TfrmCust = class(TForm)
    img: TImage;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FFahrenheit   : Boolean;
    FIniFile      : String;
    FIni          : TIniFile;
    FslSensors,
    FslSections   : TStringList;
    FUseSaveImage : Boolean;
    FTransparent  : Boolean;
    FTransColor   : TColor;
    FDecimals     : Integer;
    procedure SetParameters(tc : TLabel; i : Integer);
    procedure SetFontParams (f : TFont; i : Integer);
    procedure CopyForm;
public
    procedure SavePosInfo(var msg : TMessage); message WM_SavePosition;
    procedure GetPosInfo(indx : Integer);
    function  SearchComponent(iTag : Word) : TComponent;
    procedure AddTempData (var msg : TMessage); message WM_TempNotify;
    procedure AlarmNotify (var msg : TMessage) ; message WM_AlarmNotify ;
    procedure InitializeForm(const sIni : String);
    procedure SaveImage (var msg : TMessage) ; message WM_SaveImage ;
  end;

var
  frmCust: TfrmCust;

implementation

{$R *.DFM}

procedure TfrmCust.SetParameters(tc : TLabel; i : Integer);
var x : Integer;
    sAlign : String;
begin
   tc.AutoSize := FALSE;
   tc.Transparent := FIni.ReadBool(FslSections.Strings[i],'Transparent',FALSE);
   sAlign := FIni.ReadString(FslSections.Strings[i],'Align','Left');
   if sAlign = 'Right' then
      tc.Alignment := taRightJustify
   else
   if sAlign = 'Center' then
      tc.Alignment := taCenter
   else
      tc.Alignment := taLeftJustify;

   try
      tc.Color := StringToColor(FIni.ReadString(FslSections.Strings[i],'Color','$000000'));
   except
      tc.Color := 0;
   end;
   tc.top := FIni.ReadInteger(FslSections.Strings[i],'Top',0);
   tc.left := FIni.ReadInteger(FslSections.Strings[i],'Left',0);
   tc.width := FIni.ReadInteger(FslSections.Strings[i],'width',100);
   tc.height := FIni.ReadInteger(FslSections.Strings[i],'Height',100);
   tc.Hint := FIni.ReadString(FslSections.Strings[i],'Caption','');
   tc.ShowHint := FALSE;
   x := FslSensors.IndexOf(FslSections.Strings[i]);

   if x > -1 then
      tc.Tag := x + 1
   else
      tc.Tag := 9999;
end;

procedure TfrmCust.SetFontParams (f : TFont; i : Integer);
begin
   with f do
   begin
      f.Height := FIni.ReadInteger(FslSections.Strings[i],'Height',12);
      f.Name := FIni.ReadString(FslSections.Strings[i],'FontName','Courier');

      if FIni.ReadBool(FslSections.Strings[i],'FontBold',FALSE) then
         f.Style := f.Style + [fsBold]
      else
         f.Style := f.Style - [fsBold];

      if FIni.ReadBool(FslSections.Strings[i],'FontItalic',FALSE) then
         f.Style := f.Style + [fsItalic]
      else
         f.Style := f.Style - [fsItalic];

      try
         f.Color := StringToColor(FIni.ReadString(FslSections.Strings[i],'FontColor','$000000'));
      except
         f.Color := 0;
      end;
   end;
end;

procedure TfrmCust.InitializeForm(const sIni : String);
var i  : Integer;
    tc : TLabel;
    sBack : String;
begin
   FIniFile := sIni;
   Caption := (Copy(sIni,1,Pos('.',sIni)-1));;
   if not FileExists('.\'+FIniFile) then
   begin
      ShowMessage('CustomForm initialization file not found: '+FIniFile);
      Exit;
   end;
   FIni := TIniFile.Create('.\'+FIniFile);
   top := FIni.ReadInteger('Main','Top',0);
   left := FIni.ReadInteger('Main','Left',0);
   width := FIni.ReadInteger('Main','Width',100);
   height := FIni.ReadInteger('Main','Height',100);
   FFahrenheit := FIni.ReadBool('Main','UseFahrenheit',FALSE);
   FUseSaveImage := FIni.ReadBool('Main','CreateImage',FALSE);
   FTransparent := FIni.ReadBool('Main','Transparent',FALSE);
   FTransColor := StringToColor(FIni.ReadString('Main','TransparentColor','$000000'));
   FDecimals := FIni.ReadInteger('Main','Decimals',2);
   try
      sBack := FIni.ReadString('Main','Back','');
      img.Picture.LoadFromFile(sBack);
   except
      ShowMessage('Invalid picture or file not found: '+sBack);
   end;
   FslSections := TStringList.Create;
   FIni.ReadSections(FslSections);
   for i := 0 to FslSections.Count - 1 do
   begin
      if FslSections.Strings[i] <> 'Main' then
      begin
         tc := TLabel.Create(self);
         tc.Parent := self;

         SetParameters(tc, i);
         // if Tag is now 9999 then this is an ordinary Label and Hint contains
         // the desired Caption. Otherwise Hint contains the formatstring for
         // Caption
         if tc.Tag = 9999 then
            tc.Caption := TLabel(tc).Hint;

         SetFontParams (tc.Font, i);
      end;
   end;

   FreeAndNil(FslSections);
   FreeAndNil(FIni);
   Invalidate;
end;

procedure TfrmCust.FormCreate(Sender: TObject);
begin
   FslSensors := TStringList.Create;
   pub.RegGetSensorNames(FslSensors);
end;


procedure TfrmCust.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
   FreeAndNil(FslSensors);
end;


function TfrmCust.SearchComponent(iTag : Word) : TComponent;
var   i : Integer;
begin
{
   Search component that has desired Tag
}
   result := nil;
   for i := 1 to ComponentCount do
      if (Components[i-1]).Tag = iTag then
         result := (Components[i-1]);
end;


procedure TfrmCust.GetPosInfo(indx : Integer);
begin
   FIniFile := pub.RegGetString('Windows',IntToStr(indx),'FormFile');
   if FIniFile <> '' then
      InitializeForm(FIniFile);
   Top := pub.RegGetInt('Windows',IntToStr(indx),'Top',0);
   Left := pub.RegGetInt('Windows',IntToStr(indx),'Left',0);
   Width := pub.RegGetInt('Windows',IntToStr(indx),'Width',350);
   Height := pub.RegGetInt('Windows',IntToStr(indx),'Height',350);
   ShowWindow(Handle,pub.RegGetInt('Windows',IntToStr(indx),'State',SW_SHOWNORMAL));
end;


procedure TfrmCust.SavePosInfo(var msg : TMessage);
var indx : Integer;
    DLLFileName : array[0..MAX_PATH] of char;
begin
   //Get the DLL filename with full path first
   //hInstance is the handle provided by Windows for an application or library.
   FillChar(DLLFileName, sizeof(DLLFileName), #0);
   GetModuleFileName(hInstance, DLLFileName, sizeof(DLLFileName));

   indx := msg.LParam;
   //Mandatory
   pub.RegPutInt('Windows',IntToStr(indx),'Type',99); // Type must be 99
   pub.RegPutString('Windows',IntToStr(indx),'Plugin',ExtractFileName(DLLFileName));

   //Additional
   pub.RegPutString('Windows',IntToStr(indx),'FormFile',FIniFile);

   pub.SaveWindowPos(Handle,indx);
end;


procedure TfrmCust.AddTempData (var msg : TMessage);
var ctrTemp : TComponent;
    dTemp   : Double;
    sScaleSuffix,
    sTemp,
    sFormat : String;
begin
   //msg.WParam contains the Tag of the sensor
   ctrTemp := SearchComponent(msg.wParam);
   if ctrTemp <> nil then
   begin
      // msg.LParam contains the temperature multiplied by 100
      dTemp := msg.lParam / 100;
      if dTemp > -998 then
      begin
         sScaleSuffix := 'C';
         if FFahrenheit then
         begin
            dTemp := dTemp*9/5 + 32;
            sScaleSuffix := 'F';
         end;

         sFormat := '0.'+ StringOfChar('0', FDecimals);
         sTemp := FormatFloat(sFormat,dTemp)+sScaleSuffix;
      end
      else
         // No updates for a long time
         sTemp := '-------';
      if ctrTemp is TLabel then
         (ctrTemp as TLabel).Caption := Format((ctrTemp as TLabel).Hint,[sTemp]);
   end;
end;

procedure TfrmCust.AlarmNotify (var msg : TMessage);
var ctrTemp : TComponent;
    Ini     : TIniFile;
    sCol    : String;
begin
   ctrTemp := SearchComponent(msg.wParam);
   // wParam = Sensor lParam= 2=High 1=Low 0=No alarm ;
   if ctrTemp <> nil then
   begin
      Ini := TIniFile.Create('.\'+FIniFile);
      try
         case msg.LParam of
            0 : sCol := 'FontColor';
            1 : sCol := 'FontAlarmLoColor';
            2 : sCol := 'FontAlarmHiColor';
          end;

         if (ctrTemp is TLabel) then
            TLabel(ctrTemp).Font.Color := StringToColor(
                                          Ini.ReadString(FslSensors.Strings[msg.wParam-1],
                                          sCol,'$000000'));
      finally
         FreeAndNil(Ini);
      end;
   end;
end;

procedure TfrmCust.SaveImage (var msg : TMessage);
begin
   if FUseSaveImage then
      CopyForm;
end;

procedure TfrmCust.CopyForm;
var bm         : TBitMap;
    i          : Integer;
    hSrcDC     : THandle;
    sImagePath : String;
    iImageType : Integer;
    JPEGImage  : TJPEGImage;
    rect       : TRect;
    PNGImage   : TPNGObject;
begin
   sImagePath := pub.RegGetString('General','','ImagePath');
   if sImagePath = '' then
      sImagePath := '.\';
   iImageType := pub.RegGetInt('General','','ImageType',1);

   try
      bm := self.GetFormImage;

      case iImageType of
         0  :  try
                  bm.SaveToFile(sImagePath+'cuf_'+self.Caption+'.bmp');
               except
               end;
         1  :  begin
                  JPEGImage := TJPEGImage.Create;
                  try
                     with JPEGImage do
                     begin
                        Scale := jsFullSize;
                        PixelFormat := jf24bit;
                        CompressionQuality := 100;
                        Assign(bm);
                        Compress;
                        try
                           SaveToFile(sImagePath+'cuf_'+self.Caption+'.jpg');
                        except
                        end;
                     end;
                  finally
                     JPEGImage.Free;
                  end;
               end;
         2  :  begin
                  PNGImage := TPNGObject.Create;
                  try
                     PNGImage.AssignHandle(bm.Handle,FTransparent,FTransColor);
                     PNGImage.SaveToFile (sImagePath+'cuf_'+self.Caption+'.png');
                  finally
                     PNGImage.Free;
                  end;
               end;
      end;
      i := ReleaseDC(self.Handle,hSrcDC);
   finally
      bm.Free;
   end;
end;

end.


